#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_UserRole : BaseTest 
	{
		private const COMMON.UserRoleType TestRoleType = COMMON.UserRoleType.Technologist;
		private UserRole _testUserRole;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			_testUserRole = new UserRole( TestRoleType );
		}

		[Test]
		public void Ctor_testUserRoleType_Pass()
		{
			BOL.UserRole tmpUR = new BOL.UserRole(Common.UserRoleType.Technologist);

			Assert.IsTrue(tmpUR.UserRoleId == Common.UserRoleType.Technologist);
			Assert.IsTrue(tmpUR.UserRoleName == "Technologist");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_testUserRoleType_Fail() {}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.UserRole tmpUR = new BOL.UserRole(DAL.ReferenceData.GetUserRole( (int)Common.UserRoleType.Technologist ));

			Assert.IsTrue(tmpUR.UserRoleId == Common.UserRoleType.Technologist);
			Assert.IsTrue(tmpUR.UserRoleName == "Technologist");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentNullException))]
		public void Ctor_DataRow_Fail()
		{
			DataRow _dt = null;
			BOL.UserRole tmpUR = new BOL.UserRole(_dt);
		}

		[Test]
		public void UserRoleName_Pass()
		{
			string _testUserRoleName = _testUserRole.UserRoleName;
			Assert.AreEqual( _testUserRole.UserRoleName, _testUserRoleName );		
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void UserRoleName_Fail() {}

		[Test]
		public void UserRoleId_Pass()
		{
			Assert.AreEqual( TestRoleType , _testUserRole.UserRoleId );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void UserRoleId_Fail() {}

		[Test]
		public void GetAll_Pass()
		{
			Assert.IsTrue( UserRole.GetAll().Count > 0 );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ParameterlessMethod )]
		public void GetAll_Fail() {}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataTable _dt = new DataTable();
			_dt.Columns.Add( TABLES.UserRole.UserRoleId, typeof(int) );

			DataRow _dr = _dt.NewRow();

			_testUserRole.LoadDataRowFromThis( _dr );

			Assert.AreEqual( (int)TestRoleType, ( (int)_dr[ TABLES.UserRole.UserRoleId ] ) );
		}

		[Test]
		[ExpectedException( typeof(ArgumentNullException) )]
		public void LoadDataRowFromThis_Fail() 
		{
			_testUserRole.LoadDataRowFromThis( null );
		}
	}
}
#endif


